%--------------------------------------------------------------------------
% File     : SET075=UnOrdPrAxCor5-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Corollary to unordered pair axiom
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  161 (   8 non-Horn)(  32 unit)
%            Number of literals          :  334 ( 161 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   42 (  12 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 19992]. Corollary to UP6 to instantiate 
%            variables, in Quaife's collection.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_corollary_to_unordered_pair_axiom3_1,theorem,
    [++member(ordered_pair(x,y),cross_product(u,v))]).

input_clause(prove_corollary_to_unordered_pair_axiom3_2,theorem,
    [++equal(unordered_pair(x,y),null_class)]).
%--------------------------------------------------------------------------
