%--------------------------------------------------------------------------
% File     : SET073=UnOrdPrAxCor3-7 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Corollary to unordered pair axiom
% Version  : [Quaife, 1992] axioms : Augmented.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : UP6.1 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  185 (  15 non-Horn)(  40 unit)
%            Number of literals          :  382 ( 175 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   40 (  10 constant)
%            Number of variables         :  431 (  41 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Preceding lemmas are added.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
%----Corollaries to Unordered pair axiom. Not in paper, but in email. 
input_clause(corollary_1_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(X,unordered_pair(X,Y))]).

input_clause(corollary_2_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(Y,unordered_pair(X,Y))]).

%----Corollaries to Cartesian product axiom.
input_clause(corollary_1_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(U,universal_class)]).

input_clause(corollary_2_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(V,universal_class)]).

%----                        PARTIAL ORDER.
%----(PO1): reflexive.
input_clause(subclass_is_reflexive,axiom,
    [++subclass(X,X)]).

%----(PO2): antisymmetry is part of A-3.
%----(x < y), (y < x) --> (x = y).

%----(PO3): transitivity.
input_clause(transitivity_of_subclass,axiom,
    [--subclass(X,Y),
     --subclass(Y,Z),
     ++subclass(X,Z)]).

%----                          EQUALITY.
%----(EQ1): equality axiom.
%----a:x:(x = x).
%----This is always an axiom in the TPTP presentation.

%----substitutivity.
%----Not in the paper, and always an axiom in the TPTP presentation 

%----(EQ2): expanded equality definition.
input_clause(equality1,axiom,
    [++equal(X,Y),
     ++member(not_subclass_element(X,Y),X),
     ++member(not_subclass_element(Y,X),Y)]).

input_clause(equality2,axiom,
    [--member(not_subclass_element(X,Y),Y),
     ++equal(X,Y),
     ++member(not_subclass_element(Y,X),Y)]).

input_clause(equality3,axiom,
    [--member(not_subclass_element(Y,X),X),
     ++equal(X,Y),
     ++member(not_subclass_element(X,Y),X)]).

input_clause(equality4,axiom,
    [--member(not_subclass_element(X,Y),Y),
     --member(not_subclass_element(Y,X),X),
     ++equal(X,Y)]).

%----                        SPECIAL CLASSES.
%----(SP1): lemma.
input_clause(special_classes_lemma,axiom,
    [--member(Y,intersection(complement(X),X))]).

%----(SP2):  Existence of O (null class).
%----e:x:a:z:(-(z e x)).
input_clause(existence_of_null_class,axiom,
    [--member(Z,null_class)]).

%----(SP3): O is a subclass of every class.
input_clause(null_class_is_subclass,axiom,
    [++subclass(null_class,X)]).

%----corollary.
input_clause(corollary_of_null_class_is_subclass,axiom,
    [--subclass(X,null_class),
     ++equal(X,null_class)]).

%----(SP4): uniqueness of null class.
input_clause(null_class_is_unique,axiom,
    [++equal(Z,null_class),
     ++member(not_subclass_element(Z,null_class),Z)]).

%----(SP5): O is a set (follows from axiom of infinity).
input_clause(null_class_is_a_set,axiom,
    [++member(null_class,universal_class)]).

%----                      UNORDERED PAIRS.
%----(UP1): unordered pair is commutative.
input_clause(commutativity_of_unordered_pair,axiom,
    [++equal(unordered_pair(X,Y),unordered_pair(Y,X))]).

%----(UP2): if one argument is a proper class, pair contains only the 
%----other. In a slightly different form to the paper 
input_clause(singleton_in_unordered_pair1,axiom,
    [++subclass(singleton(X),unordered_pair(X,Y))]).

input_clause(singleton_in_unordered_pair2,axiom,
    [++subclass(singleton(Y),unordered_pair(X,Y))]).

input_clause(unordered_pair_equals_singleton1,axiom,
    [++member(Y,universal_class),
     ++equal(unordered_pair(X,Y),singleton(X))]).

input_clause(unordered_pair_equals_singleton2,axiom,
    [++member(X,universal_class),
     ++equal(unordered_pair(X,Y),singleton(Y))]).

%----(UP3): if both arguments are proper classes, pair is null. 
input_clause(null_unordered_pair,axiom,
    [++equal(unordered_pair(X,Y),null_class),
     ++member(X,universal_class),
     ++member(Y,universal_class)]).

%----(UP4): left cancellation for unordered pairs.
input_clause(left_cancellation,axiom,
    [--equal(unordered_pair(X,Y),unordered_pair(X,Z)),
     --member(ordered_pair(Y,Z),cross_product(universal_class,universal_class)),
     ++equal(Y,Z)]).

%----(UP5): right cancellation for unordered pairs.
input_clause(right_cancellation,axiom,
    [--equal(unordered_pair(X,Z),unordered_pair(Y,Z)),
     --member(ordered_pair(X,Y),cross_product(universal_class,universal_class)),
     ++equal(X,Y)]).

input_clause(prove_corollary_to_unordered_pair_axiom1_1,theorem,
    [++member(x,universal_class)]).

input_clause(prove_corollary_to_unordered_pair_axiom1_2,theorem,
    [++equal(unordered_pair(x,y),null_class)]).
%--------------------------------------------------------------------------
