%--------------------------------------------------------------------------
% File     : SET068=UOrdPrArg2-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Proper class in an unordered pair, part 2
% Version  : [Quaife, 1992] axioms.
% English  : If one argument of an unordered pair is a proper class, the 
%            pair contains only the other.

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : UP2.2 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  160 (   8 non-Horn)(  31 unit)
%            Number of literals          :  333 ( 160 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   40 (  10 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_singleton_in_unordered_pair2_1,theorem,
    [--subclass(singleton(y),unordered_pair(x,y))]).
%--------------------------------------------------------------------------
