%--------------------------------------------------------------------------
% File     : SET063=NullClSubClCor1-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Corollary to the null class being a subclass of every class
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : SP3 cor. [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  161 (   8 non-Horn)(  32 unit)
%            Number of literals          :  334 ( 161 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   39 (   9 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_corollary_of_null_class_is_subclass_1,theorem,
    [++subclass(x,null_class)]).

input_clause(prove_corollary_of_null_class_is_subclass_2,theorem,
    [--equal(x,null_class)]).
%--------------------------------------------------------------------------
