%--------------------------------------------------------------------------
% File     : SET062=NullClSubCl-7 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : The null class is a subclass of every class
% Version  : [Quaife, 1992] axioms : Augmented.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : SP3 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  172 (  11 non-Horn)(  34 unit)
%            Number of literals          :  359 ( 164 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   39 (   9 constant)
%            Number of variables         :  410 (  38 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Preceding lemmas are added.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
%----Corollaries to Unordered pair axiom. Not in paper, but in email. 
input_clause(corollary_1_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(X,unordered_pair(X,Y))]).

input_clause(corollary_2_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(Y,unordered_pair(X,Y))]).

%----Corollaries to Cartesian product axiom.
input_clause(corollary_1_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(U,universal_class)]).

input_clause(corollary_2_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(V,universal_class)]).

%----                        PARTIAL ORDER.
%----(PO1): reflexive.
input_clause(subclass_is_reflexive,axiom,
    [++subclass(X,X)]).

%----(PO2): antisymmetry is part of A-3.
%----(x < y), (y < x) --> (x = y).

%----(PO3): transitivity.
input_clause(transitivity_of_subclass,axiom,
    [--subclass(X,Y),
     --subclass(Y,Z),
     ++subclass(X,Z)]).

%----                          EQUALITY.
%----(EQ1): equality axiom.
%----a:x:(x = x).
%----This is always an axiom in the TPTP presentation.

%----substitutivity.
%----Not in the paper, and always an axiom in the TPTP presentation 

%----(EQ2): expanded equality definition.
input_clause(equality1,axiom,
    [++equal(X,Y),
     ++member(not_subclass_element(X,Y),X),
     ++member(not_subclass_element(Y,X),Y)]).

input_clause(equality2,axiom,
    [--member(not_subclass_element(X,Y),Y),
     ++equal(X,Y),
     ++member(not_subclass_element(Y,X),Y)]).

input_clause(equality3,axiom,
    [--member(not_subclass_element(Y,X),X),
     ++equal(X,Y),
     ++member(not_subclass_element(X,Y),X)]).

input_clause(equality4,axiom,
    [--member(not_subclass_element(X,Y),Y),
     --member(not_subclass_element(Y,X),X),
     ++equal(X,Y)]).

%----                        SPECIAL CLASSES.
%----(SP1): lemma.
input_clause(special_classes_lemma,axiom,
    [--member(Y,intersection(complement(X),X))]).

%----(SP2):  Existence of O (null class).
%----e:x:a:z:(-(z e x)).
input_clause(existence_of_null_class,axiom,
    [--member(Z,null_class)]).

input_clause(prove_null_class_is_subclass_1,theorem,
    [--subclass(null_class,x)]).
%--------------------------------------------------------------------------
