%--------------------------------------------------------------------------
% File     : SET055=EqRefl-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Equality is reflexive
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : EQ1 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  159 (   8 non-Horn)(  30 unit)
%            Number of literals          :  332 ( 160 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   39 (   9 constant)
%            Number of variables         :  378 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Don't include axioms of equality, as reflexivity is proved here 
% include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(symmetry,axiom,
    [--equal(X,Y),
     ++equal(Y,X)]).

input_clause(transitivity,axiom,
    [--equal(X,Y),
     --equal(Y,Z),
     ++equal(X,Z)]).

input_clause(prove_reflexivity,theorem,
    [--equal(x,x)]).
%--------------------------------------------------------------------------
