%--------------------------------------------------------------------------
% File     : SET054=SubCRefl-7 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Subclass is reflexive
% Version  : [Quaife, 1992] axioms : Augmented.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : PO1 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  164 (   8 non-Horn)(  31 unit)
%            Number of literals          :  341 ( 160 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   39 (   9 constant)
%            Number of variables         :  395 (  36 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Preceding lemmas are added.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
%----Corollaries to Unordered pair axiom. Not in paper, but in email. 
input_clause(corollary_1_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(X,unordered_pair(X,Y))]).

input_clause(corollary_2_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(Y,unordered_pair(X,Y))]).

%----Corollaries to Cartesian product axiom.
input_clause(corollary_1_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(U,universal_class)]).

input_clause(corollary_2_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(V,universal_class)]).

input_clause(prove_subclass_is_reflexive_1,theorem,
    [--subclass(x,x)]).
%--------------------------------------------------------------------------
