%--------------------------------------------------------------------------
% File     : SET047=EqSymm-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Set equality is symmetric
% Version  : 
% English  : Define set equality as having exactly the same members. Prove 
%            set equality is symmetric.

% Refs     : De Champeaux D. (1979), Sub-problem Finder and Instance 
%            Checker: Two cooperating preprocessors for theorem provers, 
%            Proceedings of the 6th International Joint Conference 
%            on Artificial Intelligence, 191-196.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 43 [Pelletier, 1986]
%          : p43.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    6 (   2 non-Horn)(   0 unit)
%            Number of literals          :   16 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :   10 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(element_substitution1,axiom,
    [--set_equal(X,Y),
     --element(Z,X),
     ++element(Z,Y)]).

input_clause(element_substitution2,axiom,
    [--set_equal(X,Y),
     --element(Z,Y),
     ++element(Z,X)]).

input_clause(clause_3,axiom,
    [++element(f(X,Y),X),
     ++element(f(X,Y),Y),
     ++set_equal(X,Y)]).

input_clause(clause_4,axiom,
    [--element(f(X,Y),Y),
     --element(f(X,Y),X),
     ++set_equal(X,Y)]).

input_clause(prove_symmetry1,theorem,
    [++set_equal(a,b),
     ++set_equal(b,a)]).

input_clause(prove_symmetry2,theorem,
    [--set_equal(b,a),
     --set_equal(a,b)]).
%--------------------------------------------------------------------------
