%--------------------------------------------------------------------------
% File     : SET046=NotCirc-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : No set of non-circular sets
% Version  : 
% English  : A set is circular if it is a member of another set which 
%            in turn is a member of the orginal. Intuitively all sets are 
%            non-circular. Prove there is no set of non-circular sets.

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 42 [Pelletier, 1986]
%          : p42.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    3 (   2 non-Horn)(   0 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    2 (   1 constant)
%            Number of variables         :    4 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--element(X,a),
     --element(X,Y),
     --element(Y,X)]).

input_clause(clause_2,theorem,
    [++element(X,f(X)),
     ++element(X,a)]).

input_clause(clause_3,theorem,
    [++element(f(X),X),
     ++element(X,a)]).
%--------------------------------------------------------------------------
