%--------------------------------------------------------------------------
% File     : SET045=NotUnivSet-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : No Universal Set
% Version  : 
% English  : The restricted comprehension axiom says : given a set 
%            z, there is a set all of whose members are drawn from z and 
%            which satisfy some property. If there were a universal set, 
%            then the Russell set could be formed, using this axiom. 
%            So given the appropriate instance of this axiom, there 
%            is no universal set.

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 41 [Pelletier, 1986]
%          : p41.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    4 (   1 non-Horn)(   1 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    2 (   1 constant)
%            Number of variables         :    7 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [--element(X,f(Y)),
     ++element(X,Y)]).

input_clause(clause_2,axiom,
    [--element(X,f(Y)),
     --element(X,X)]).

input_clause(clause_3,axiom,
    [--element(X,Y),
     ++element(X,X),
     ++element(X,f(Y))]).

input_clause(clause_4,theorem,
    [++element(X,a)]).
%--------------------------------------------------------------------------
