%--------------------------------------------------------------------------
% File     : SET044=ARussellSet-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Anti-Russell Sets
% Version  : 
% English  : If there were an anti-Russell set (a set that contains 
%            exactly those sets that are members of themselves), then not 
%            every set has a complement.

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 40 [Pelletier, 1986]
%          : p40.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :    4 (   1 non-Horn)(   0 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    2 (   1 constant)
%            Number of variables         :    6 (   0 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    2

% Comments : This problem is incorrect in [Pelletier, 1986] and is
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--element(X,a),
     ++element(X,X)]).

input_clause(clause_2,theorem,
    [--element(X,X),
     ++element(X,a)]).

input_clause(clause_3,theorem,
    [--element(Y,f(X)),
     --element(Y,X)]).

input_clause(clause_4,theorem,
    [++element(Y,X),
     ++element(Y,f(X))]).
%--------------------------------------------------------------------------
