%--------------------------------------------------------------------------
% File     : SET042=OrdPrXProd-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Ordered pairs are in cross products
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 27 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  269 (  20 non-Horn)(  15 unit)
%            Number of literals          :  632 ( 273 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   63 (  10 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(member_of_set_a,hypothesis,
    [++member(a,set_a)]).

input_clause(member_of_set_b,hypothesis,
    [++member(b,set_b)]).

input_clause(prove_ordered_pair_is_in_cross_product,theorem,
    [--member(ordered_pair(a,b),cross_product(set_a,set_b))]).
%--------------------------------------------------------------------------
