%--------------------------------------------------------------------------
% File     : SET040=ApplyCpsn2-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Properties of apply for composition of functions, 2 of 3
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 25 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  268 (  20 non-Horn)(  14 unit)
%            Number of literals          :  631 ( 273 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   62 (   9 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_function,hypothesis,
    [++function(a_function)]).

input_clause(prove_apply_for_composition2,theorem,
    [--subset(apply(composition(another_function,a_function),element),
apply(another_function,apply(a_function,element)))]).
%--------------------------------------------------------------------------
