%--------------------------------------------------------------------------
% File     : SET038=ApplyFunc3-6 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Set Theory
% Problem  : Properties of apply for functions, part 3 of 3
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : MA2 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  190 (   8 non-Horn)(  41 unit)
%            Number of literals          :  389 ( 181 equality)
%            Number of predicate symbols :   11 (   0 propositional)
%            Number of function symbols  :   50 (  16 constant)
%            Number of variables         :  437 (  33 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 1992]. Theorem MA2 in Quaife's collection.
%          : This problem has been removed from its position in Quaife's 
%            order of presentation because it corresponds to one 
%            of Bledsoe, et al.'s [1986] problems. If the user wishes 
%            to create augmented versions of the Quaife problems, the 
%            Theorem name above indicates its position in Quaife's 
%            ordering.
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include von Neuman-Bernays-Godel Boolean Algebra definitions 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%--------------------------------------------------------------------------
input_clause(prove_mapping_property1_1,theorem,
    [++maps(xf,xd,xr)]).

input_clause(prove_mapping_property1_2,theorem,
    [++member(x,xd)]).

input_clause(prove_mapping_property1_3,theorem,
    [--member(apply(xf,x),xr)]).
%--------------------------------------------------------------------------
