%--------------------------------------------------------------------------
% File     : SET038=ApplyFunc3-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Properties of apply for functions, part 3 of 3
% Version  : [Boyer, et al., 1986] axioms : Augmented.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 23 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  291 (  20 non-Horn)(  20 unit)
%            Number of literals          :  690 ( 285 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   63 (  10 constant)
%            Number of variables         :  783 (  36 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
%----Previously proved lemmas are added at each step 
input_clause(first_components_are_equal,axiom,
    [--little_set(X),
     --little_set(U),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(X,U)]).

input_clause(left_cancellation,axiom,
    [--little_set(X),
     --little_set(Y),
     --equal(non_ordered_pair(Z,X),non_ordered_pair(Z,Y)),
     ++equal(X,Y)]).

input_clause(second_components_are_equal,axiom,
    [--little_set(X),
     --little_set(Y),
     --little_set(U),
     --little_set(V),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(Y,V)]).

input_clause(two_sets_equal,axiom,
    [--subset(X,Y),
     --subset(Y,X),
     ++equal(X,Y)]).

input_clause(property_of_first,axiom,
    [--little_set(X),
     --little_set(Y),
     ++equal(first(ordered_pair(X,Y)),X)]).

input_clause(property_of_second,axiom,
    [--little_set(X),
     --little_set(Y),
     ++equal(second(ordered_pair(X,Y)),Y)]).

input_clause(first_component_is_small,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(first(X))]).

input_clause(second_component_is_small,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(second(X))]).

input_clause(property_of_singleton_sets,axiom,
    [--little_set(X),
     ++member(X,singleton_set(X))]).

input_clause(ordered_pairs_are_small1,axiom,
    [++little_set(ordered_pair(X,Y))]).

input_clause(ordered_pairs_are_small2,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(X)]).

input_clause(containment_is_transitive,axiom,
    [--subset(X,Y),
     --subset(Y,Z),
     ++subset(X,Z)]).

input_clause(image_and_apply1,axiom,
    [++subset(apply(Xf,Y),sigma(image(singleton_set(Y),Xf)))]).

input_clause(image_and_apply2,axiom,
    [++subset(image(singleton_set(Y),Xf),apply(Xf,Y))]).

input_clause(function_values_are_small,axiom,
    [--function(Y),
     ++little_set(apply(Y,X))]).

input_clause(composition_is_a_relation,axiom,
    [++relation(composition(Y,X))]).

input_clause(range_of_composition,axiom,
    [++subset(range_of(composition(Y,X)),range_of(Y))]).

input_clause(domain_of_composition,axiom,
    [--subset(range_of(X),domain_of(Y)),
     ++equal(domain_of(X),domain_of(composition(Y,X)))]).

input_clause(composition_is_a_function,axiom,
    [--function(X),
     --function(Y),
     ++function(composition(Y,X))]).

input_clause(maps_for_composition,axiom,
    [--maps(Xf,U,V),
     --maps(Xg,V,W),
     ++maps(composition(Xg,Xf),U,W)]).

input_clause(apply_for_functions1,axiom,
    [--little_set(X),
     --little_set(Y),
     --function(Xf),
     --member(ordered_pair(X,Y),Xf),
     ++equal(apply(Xf,X),Y)]).

input_clause(apply_for_functions2,axiom,
    [--function(Xf),
     --member(X,domain_of(Xf)),
     --equal(apply(Xf,X),Y),
     ++member(ordered_pair(X,Y),Xf)]).

input_clause(a_mapping,hypothesis,
    [++maps(a_function,a_domain,a_range)]).

input_clause(member_of_domain,hypothesis,
    [++member(a,a_domain)]).

input_clause(prove_mapping_in_range,theorem,
    [--member(apply(a_function,a),a_range)]).
%--------------------------------------------------------------------------
