%--------------------------------------------------------------------------
% File     : SET036=ApplyFunc1-6 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Set Theory
% Problem  : Properties of apply for functions, part 1 of 3
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : AP9 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  191 (   8 non-Horn)(  42 unit)
%            Number of literals          :  390 ( 182 equality)
%            Number of predicate symbols :   11 (   0 propositional)
%            Number of function symbols  :   49 (  15 constant)
%            Number of variables         :  437 (  33 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : This problem has been removed from its position in Quaife's 
%            order of presentation because it corresponds to one 
%            of Bledsoe, et al.'s [1986] problems. If the user wishes 
%            to create augmented versions of the Quaife problems, the 
%            Theorem name above indicates its position in Quaife's 
%            ordering.
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include von Neuman-Bernays-Godel Boolean Algebra definitions 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%--------------------------------------------------------------------------
input_clause(prove_application_property9_1,theorem,
    [++function(xf)]).

input_clause(prove_application_property9_2,theorem,
    [++member(ordered_pair(x,y),xf)]).

input_clause(prove_application_property9_3,theorem,
    [++member(ordered_pair(x,y),cross_product(universal_class,
universal_class))]).

input_clause(prove_application_property9_4,theorem,
    [--equal(apply(xf,x),y)]).
%--------------------------------------------------------------------------
