%--------------------------------------------------------------------------
% File     : SET034=CpsnFuncs-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : The composition of functions is a function
% Version  : [Boyer, et al., 1986] axioms : Augmented.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 19 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  287 (  20 non-Horn)(  20 unit)
%            Number of literals          :  675 ( 283 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   61 (   8 constant)
%            Number of variables         :  770 (  36 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
%----Previously proved lemmas are added at each step 
input_clause(first_components_are_equal,axiom,
    [--little_set(X),
     --little_set(U),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(X,U)]).

input_clause(left_cancellation,axiom,
    [--little_set(X),
     --little_set(Y),
     --equal(non_ordered_pair(Z,X),non_ordered_pair(Z,Y)),
     ++equal(X,Y)]).

input_clause(second_components_are_equal,axiom,
    [--little_set(X),
     --little_set(Y),
     --little_set(U),
     --little_set(V),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(Y,V)]).

input_clause(two_sets_equal,axiom,
    [--subset(X,Y),
     --subset(Y,X),
     ++equal(X,Y)]).

input_clause(property_of_first,axiom,
    [--little_set(X),
     --little_set(Y),
     ++equal(first(ordered_pair(X,Y)),X)]).

input_clause(property_of_second,axiom,
    [--little_set(X),
     --little_set(Y),
     ++equal(second(ordered_pair(X,Y)),Y)]).

input_clause(first_component_is_small,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(first(X))]).

input_clause(second_component_is_small,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(second(X))]).

input_clause(property_of_singleton_sets,axiom,
    [--little_set(X),
     ++member(X,singleton_set(X))]).

input_clause(ordered_pairs_are_small1,axiom,
    [++little_set(ordered_pair(X,Y))]).

input_clause(ordered_pairs_are_small2,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(X)]).

input_clause(containment_is_transitive,axiom,
    [--subset(X,Y),
     --subset(Y,Z),
     ++subset(X,Z)]).

input_clause(image_and_apply1,axiom,
    [++subset(apply(Xf,Y),sigma(image(singleton_set(Y),Xf)))]).

input_clause(image_and_apply2,axiom,
    [++subset(image(singleton_set(Y),Xf),apply(Xf,Y))]).

input_clause(function_values_are_small,axiom,
    [--function(Y),
     ++little_set(apply(Y,X))]).

input_clause(composition_is_a_relation,axiom,
    [++relation(composition(Y,X))]).

input_clause(range_of_composition,axiom,
    [++subset(range_of(composition(Y,X)),range_of(Y))]).

input_clause(domain_of_composition,axiom,
    [--subset(range_of(X),domain_of(Y)),
     ++equal(domain_of(X),domain_of(composition(Y,X)))]).

input_clause(a_function,hypothesis,
    [++function(a_function)]).

input_clause(another_function,hypothesis,
    [++function(another_function)]).

input_clause(prove_their_composition_is_a_function,theorem,
    [--function(composition(another_function,a_function))]).
%--------------------------------------------------------------------------
