%--------------------------------------------------------------------------
% File     : SET033=DomCpsn-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Domain of composition
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 18 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  268 (  20 non-Horn)(  14 unit)
%            Number of literals          :  631 ( 274 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   61 (   8 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(range_subset_of_domain,hypothesis,
    [++subset(range_of(a),domain_of(b))]).

input_clause(prove_domain_of_composition,theorem,
    [--equal(domain_of(a),domain_of(composition(b,a)))]).
%--------------------------------------------------------------------------
