%--------------------------------------------------------------------------
% File     : SET028=Apply_Img1-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Relationship between apply and image, part 1 of 2
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 13 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  267 (  20 non-Horn)(  13 unit)
%            Number of literals          :  630 ( 273 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   61 (   8 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_property_of_image_and_apply1,theorem,
    [--subset(apply(a_function,element),
sigma(image(singleton_set(element),a_function)))]).
%--------------------------------------------------------------------------
