%--------------------------------------------------------------------------
% File     : SET023=2ndCpntSet-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : The second component of an ordered pair is a little set
% Version  : [Boyer, et al., 1986] axioms : Augmented.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 8 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  275 (  20 non-Horn)(  14 unit)
%            Number of literals          :  656 ( 282 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   60 (   7 constant)
%            Number of variables         :  750 (  30 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
%----Previously proved lemmas are added at each step 
input_clause(first_components_are_equal,axiom,
    [--little_set(X),
     --little_set(U),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(X,U)]).

input_clause(left_cancellation,axiom,
    [--little_set(X),
     --little_set(Y),
     --equal(non_ordered_pair(Z,X),non_ordered_pair(Z,Y)),
     ++equal(X,Y)]).

input_clause(second_components_are_equal,axiom,
    [--little_set(X),
     --little_set(Y),
     --little_set(U),
     --little_set(V),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(Y,V)]).

input_clause(two_sets_equal,axiom,
    [--subset(X,Y),
     --subset(Y,X),
     ++equal(X,Y)]).

input_clause(property_of_first,axiom,
    [--little_set(X),
     --little_set(Y),
     ++equal(first(ordered_pair(X,Y)),X)]).

input_clause(property_of_second,axiom,
    [--little_set(X),
     --little_set(Y),
     ++equal(second(ordered_pair(X,Y)),Y)]).

input_clause(first_component_is_small,axiom,
    [--ordered_pair_predicate(X),
     ++little_set(first(X))]).

input_clause(an_ordered_pair_predicate,hypothesis,
    [++ordered_pair_predicate(a)]).

input_clause(prove_second_component_is_small,theorem,
    [--little_set(second(a))]).
%--------------------------------------------------------------------------
