%--------------------------------------------------------------------------
% File     : SET019=SetsEq-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Two sets that contain one another are equal
% Version  : [Boyer, et al., 1986] axioms : Augmented.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 4 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  272 (  20 non-Horn)(  15 unit)
%            Number of literals          :  646 ( 280 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   61 (   8 constant)
%            Number of variables         :  743 (  30 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
%----Previously proved lemmas are added at each step 
input_clause(first_components_are_equal,axiom,
    [--little_set(X),
     --little_set(U),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(X,U)]).

input_clause(left_cancellation,axiom,
    [--little_set(X),
     --little_set(Y),
     --equal(non_ordered_pair(Z,X),non_ordered_pair(Z,Y)),
     ++equal(X,Y)]).

input_clause(second_components_are_equal,axiom,
    [--little_set(X),
     --little_set(Y),
     --little_set(U),
     --little_set(V),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(Y,V)]).

input_clause(a_contains_b,hypothesis,
    [++subset(b,a)]).

input_clause(b_contains_a,hypothesis,
    [++subset(a,b)]).

input_clause(prove__a_equals_b,theorem,
    [--equal(a,b)]).
%--------------------------------------------------------------------------
