%--------------------------------------------------------------------------
% File     : SET018=2ndCpntsEq-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Second components of equal ordered pairs are equal
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OP5 [Quaife, 1992]
%          : OP11 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  162 (   8 non-Horn)(  33 unit)
%            Number of literals          :  335 ( 162 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   42 (  12 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_ordered_pair_determines_components2_1,theorem,
    [++equal(ordered_pair(w,x),ordered_pair(y,z))]).

input_clause(prove_ordered_pair_determines_components2_2,theorem,
    [++member(x,universal_class)]).

input_clause(prove_ordered_pair_determines_components2_3,theorem,
    [--equal(x,z)]).
%--------------------------------------------------------------------------
