%--------------------------------------------------------------------------
% File     : SET018=2ndCpntsEq-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Second components of equal ordered pairs are equal
% Version  : [Boyer, et al., 1986] axioms : Augmented.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 3 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  274 (  20 non-Horn)(  18 unit)
%            Number of literals          :  643 ( 279 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   63 (  10 constant)
%            Number of variables         :  739 (  30 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
%----Previously proved lemmas are added at each step 
input_clause(first_components_are_equal,axiom,
    [--little_set(X),
     --little_set(U),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(X,U)]).

input_clause(left_cancellation,axiom,
    [--little_set(X),
     --little_set(Y),
     --equal(non_ordered_pair(Z,X),non_ordered_pair(Z,Y)),
     ++equal(X,Y)]).

input_clause(a_little_set,hypothesis,
    [++little_set(a)]).

input_clause(b_little_set,hypothesis,
    [++little_set(b)]).

input_clause(c_little_set,hypothesis,
    [++little_set(c)]).

input_clause(d_little_set,hypothesis,
    [++little_set(d)]).

input_clause(equal_ordered_pair,hypothesis,
    [++equal(ordered_pair(a,b),ordered_pair(c,d))]).

input_clause(prove_second_components_equal,theorem,
    [--equal(b,d)]).
%--------------------------------------------------------------------------
