%--------------------------------------------------------------------------
% File     : SET017=UOrdPrLCanc-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Left cancellation for non-ordered pairs
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : UP4 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  162 (   8 non-Horn)(  33 unit)
%            Number of literals          :  335 ( 162 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (  11 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_left_cancellation_1,theorem,
    [++equal(unordered_pair(x,y),unordered_pair(x,z))]).

input_clause(prove_left_cancellation_2,theorem,
    [++member(ordered_pair(y,z),cross_product(universal_class,
universal_class))]).

input_clause(prove_left_cancellation_3,theorem,
    [--equal(y,z)]).
%--------------------------------------------------------------------------
