%--------------------------------------------------------------------------
% File     : SET017=UOrdPrLCanc-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Left cancellation for non-ordered pairs
% Version  : [Boyer, et al., 1986] axioms : Augmented.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 2 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  271 (  20 non-Horn)(  16 unit)
%            Number of literals          :  637 ( 277 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   63 (  10 constant)
%            Number of variables         :  736 (  30 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
%----Previously proved lemmas are added at each step 
input_clause(first_components_are_equal,axiom,
    [--little_set(X),
     --little_set(U),
     --equal(ordered_pair(X,Y),ordered_pair(U,V)),
     ++equal(X,U)]).

input_clause(a_little_set,hypothesis,
    [++little_set(a)]).

input_clause(b_little_set,hypothesis,
    [++little_set(b)]).

input_clause(equal_non_ordered_pairs,hypothesis,
    [++equal(non_ordered_pair(c,a),non_ordered_pair(d,b))]).

input_clause(prove_left_cancellation,theorem,
    [--equal(a,c)]).
%--------------------------------------------------------------------------
