%--------------------------------------------------------------------------
% File     : SET016=1stCpntsEq-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : First components of equal ordered pairs are equal
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Lemma 1 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  270 (  20 non-Horn)(  16 unit)
%            Number of literals          :  633 ( 275 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   63 (  10 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(little_set_a,hypothesis,
    [++little_set(a)]).

input_clause(little_set_b,hypothesis,
    [++little_set(b)]).

input_clause(equal_ordered_pairs,hypothesis,
    [++equal(ordered_pair(a,c),ordered_pair(b,d))]).

input_clause(prove_first_components_equal,theorem,
    [--equal(a,b)]).
%--------------------------------------------------------------------------
