%--------------------------------------------------------------------------
% File     : SET016=1stCpntsEq-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : First components of equal ordered pairs are equal
% Version  : [Lusk & Wos, 1991] axioms : Incomplete.
% English  : 

% Refs     : Lusk E. and Wos L. (1991), Benchmark Problems in Which 
%            Equality Plays the Major Role, Preprint MCS-P275-1191, 
%            Mathematics and Computer Science Division, Argonne National 
%            Laboratory, Argonne, IL.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
% Source   : [Lusk & Wos, 1991]
% Names    : NU3.1 [Lusk & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :   18 (   1 non-Horn)(   7 unit)
%            Number of literals          :   33 (  24 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   38 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(singleton_1,axiom,
    [++member(X,singleton_set(X))]).

input_clause(singleton_2,axiom,
    [--member(X,singleton_set(Y)),
     ++equal(X,Y)]).

input_clause(unordered_pair_1,axiom,
    [++member(X,unordered_pair(X,Y))]).

input_clause(unordered_pair_2,axiom,
    [++member(Y,unordered_pair(X,Y))]).

input_clause(unordered_pair_3,axiom,
    [--member(X,unordered_pair(Y,Z)),
     ++equal(X,Y),
     ++equal(X,Z)]).

input_clause(ordered_pair,axiom,
    [++equal(ordered_pair(X,Y),unordered_pair(singleton_set(X),
unordered_pair(X,Y)))]).

input_clause(ordered_pair_substitution1,axiom,
    [--equal(A,B),
     ++equal(ordered_pair(A,C),ordered_pair(B,C))]).

input_clause(ordered_pair_substitution2,axiom,
    [--equal(D,E),
     ++equal(ordered_pair(F,D),ordered_pair(F,E))]).

input_clause(singleton_set_substitution1,axiom,
    [--equal(G,H),
     ++equal(singleton_set(G),singleton_set(H))]).

input_clause(unordered_pair_substitution1,axiom,
    [--equal(I,J),
     ++equal(unordered_pair(I,K),unordered_pair(J,K))]).

input_clause(unordered_pair_substitution2,axiom,
    [--equal(L,M),
     ++equal(unordered_pair(N,L),unordered_pair(N,M))]).

input_clause(member_substitution1,axiom,
    [--equal(O,P),
     --member(O,Q),
     ++member(P,Q)]).

input_clause(member_substitution2,axiom,
    [--equal(R,S),
     --member(T,R),
     ++member(T,S)]).

input_clause(equal_ordered_pairs,hypothesis,
    [++equal(ordered_pair(m1,r1),ordered_pair(m2,r2))]).

input_clause(prove_first_components_equal,theorem,
    [--equal(m1,m2)]).
%--------------------------------------------------------------------------
