%--------------------------------------------------------------------------
% File     : SET015=UnionComm-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : The union of sets is commutative
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  269 (  20 non-Horn)(  15 unit)
%            Number of literals          :  632 ( 276 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   63 (  10 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_union_b_is_c,hypothesis,
    [++equal(union(as,bs),cs)]).

input_clause(b_union_a_is_d,hypothesis,
    [++equal(union(bs,as),ds)]).

input_clause(prove_c_equals_d,theorem,
    [--equal(cs,ds)]).
%--------------------------------------------------------------------------
