%--------------------------------------------------------------------------
% File     : SET015=UnionComm-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : The union of sets is commutative
% Version  : [McCharen, et al., 1976] axioms.
%            Theorem formulation : modified.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : union.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   35 (   3 non-Horn)(   6 unit)
%            Number of literals          :   74 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    9 (   5 constant)
%            Number of variables         :   80 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include set axioms 
include('Axioms/SET002-0.ax').
include('Axioms/SET002-0.eq').
%--------------------------------------------------------------------------
input_clause(a_union_b_is_c,hypothesis,
    [++equal_sets(union(as,bs),cs)]).

input_clause(b_union_a_is_d,hypothesis,
    [++equal_sets(union(bs,as),ds)]).

input_clause(prove_c_equals_d,theorem,
    [--equal_sets(cs,ds)]).
%--------------------------------------------------------------------------
