%--------------------------------------------------------------------------
% File     : SET014=UnionOfSubS-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Union of subsets is a subset
% Version  : [Boyer, et al., 1986] axioms : Reduced > Incomplete.
% English  : If A and B are contained in C then the union of A and 
%            B is also.

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [ANL]
% Names    : subset.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   21 (   4 non-Horn)(   6 unit)
%            Number of literals          :   42 (  10 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   10 (   5 constant)
%            Number of variables         :   38 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Axiom A-2, elements of sets are little sets.
input_clause(a2,axiom,
    [--member(X,Y),
     ++little_set(X)]).

%----Axiom A-3, principle of extensionality 
input_clause(extensionality1,axiom,
    [++little_set(f1(X,Y)),
     ++equal(X,Y)]).

input_clause(extensionality2,axiom,
    [++member(f1(X,Y),X),
     ++member(f1(X,Y),Y),
     ++equal(X,Y)]).

input_clause(extensionality3,axiom,
    [--member(f1(X,Y),X),
     --member(f1(X,Y),Y),
     ++equal(X,Y)]).

%----Axiom B-2, intersection 
input_clause(intersection1,axiom,
    [--member(Z,intersection(X,Y)),
     ++member(Z,X)]).

input_clause(intersection2,axiom,
    [--member(Z,intersection(X,Y)),
     ++member(Z,Y)]).

input_clause(intersection3,axiom,
    [++member(Z,intersection(X,Y)),
     --member(Z,X),
     --member(Z,Y)]).

%----Axiom B-3, complement 
input_clause(complement1,axiom,
    [--member(Z,complement(X)),
     --member(Z,X)]).

input_clause(complement2,axiom,
    [++member(Z,complement(X)),
     --little_set(Z),
     ++member(Z,X)]).

%----Definition of union 
input_clause(union,axiom,
    [++equal(union(X,Y),complement(intersection(complement(X),
complement(Y))))]).

%----Definition of empty set 
input_clause(empty_set,axiom,
    [--member(Z,empty_set)]).

%----Definition of universal set 
input_clause(universal_set,axiom,
    [++member(Z,universal_set),
     --little_set(Z)]).

%----Definition of subset 
input_clause(subset1,axiom,
    [--subset(X,Y),
     --member(U,X),
     ++member(U,Y)]).

input_clause(subset2,axiom,
    [++subset(X,Y),
     ++member(f17(X,Y),X)]).

input_clause(subset3,axiom,
    [++subset(X,Y),
     --member(f17(X,Y),Y)]).

input_clause(a_subset_of_c,hypothesis,
    [++subset(as,cs)]).

input_clause(b_subset_of_c,hypothesis,
    [++subset(bs,cs)]).

input_clause(prove_a_union_b_subset_of_c,theorem,
    [--subset(union(as,bs),cs)]).
%--------------------------------------------------------------------------
