%--------------------------------------------------------------------------
% File     : SET014=UnionOfSubS-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Union of subsets is a subset
% Version  : [McCharen, et al., 1976] axioms.
% English  : If A and B are contained in C then the union of A and 
%            B is also.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : S4 [McCharen, et al., 1976]
%          : subset.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   35 (   3 non-Horn)(   6 unit)
%            Number of literals          :   74 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   80 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include set axioms 
include('Axioms/SET002-0.ax').
include('Axioms/SET002-0.eq').
%--------------------------------------------------------------------------
input_clause(a_subset_of_c,hypothesis,
    [++subset(as,cs)]).

input_clause(b_subset_of_c,hypothesis,
    [++subset(bs,cs)]).

input_clause(prove_a_union_b_subset_of_c,theorem,
    [--subset(union(as,bs),cs)]).
%--------------------------------------------------------------------------
