%--------------------------------------------------------------------------
% File     : SET013=IntscComm-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : The intersection of sets is commutative
% Version  : [Boyer, et al., 1986] axioms : Reduced > Incomplete.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [ANL]
% Names    : inters.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   15 (   2 non-Horn)(   5 unit)
%            Number of literals          :   29 (  12 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   6 constant)
%            Number of variables         :   25 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Axiom A-2, elements of sets are little sets.
input_clause(a2,axiom,
    [--member(X,Y),
     ++little_set(X)]).

%----Axiom A-3, principle of extensionality 
input_clause(extensionality1,axiom,
    [++little_set(f1(X,Y)),
     ++equal(X,Y)]).

input_clause(extensionality2,axiom,
    [++member(f1(X,Y),X),
     ++member(f1(X,Y),Y),
     ++equal(X,Y)]).

input_clause(extensionality3,axiom,
    [--member(f1(X,Y),X),
     --member(f1(X,Y),Y),
     ++equal(X,Y)]).

%----Axiom B-2, intersection 
input_clause(intersection1,axiom,
    [--member(Z,intersection(X,Y)),
     ++member(Z,X)]).

input_clause(intersection2,axiom,
    [--member(Z,intersection(X,Y)),
     ++member(Z,Y)]).

input_clause(intersection3,axiom,
    [++member(Z,intersection(X,Y)),
     --member(Z,X),
     --member(Z,Y)]).

%----Definition of empty set 
input_clause(empty_set,axiom,
    [--member(Z,empty_set)]).

%----Definition of universal set 
input_clause(universal_set,axiom,
    [++member(Z,universal_set),
     --little_set(Z)]).

input_clause(intersection_of_a_and_b_is_c,hypothesis,
    [++equal(intersection(as,bs),cs)]).

input_clause(intersection_of_b_and_a_is_d,hypothesis,
    [++equal(intersection(bs,as),ds)]).

input_clause(prove_c_equals_d,theorem,
    [--equal(cs,ds)]).
%--------------------------------------------------------------------------
