%--------------------------------------------------------------------------
% File     : SET012=CpmtIvln-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Complement is an involution
% Version  : [Boyer, et al., 1986] axioms : Reduced > Incomplete.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [ANL]
% Names    : compl.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   14 (   3 non-Horn)(   5 unit)
%            Number of literals          :   27 (  12 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   20 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----Axiom A-2, elements of sets are little sets.
input_clause(a2,axiom,
    [--member(X,Y),
     ++little_set(X)]).

%----Axiom A-3, principle of extensionality 
input_clause(extensionality1,axiom,
    [++little_set(f1(X,Y)),
     ++equal(X,Y)]).

input_clause(extensionality2,axiom,
    [++member(f1(X,Y),X),
     ++member(f1(X,Y),Y),
     ++equal(X,Y)]).

input_clause(extensionality3,axiom,
    [--member(f1(X,Y),X),
     --member(f1(X,Y),Y),
     ++equal(X,Y)]).

%----Axiom B-3, complement 
input_clause(complement1,axiom,
    [--member(Z,complement(X)),
     --member(Z,X)]).

input_clause(complement2,axiom,
    [++member(Z,complement(X)),
     --little_set(Z),
     ++member(Z,X)]).

%----Definition of empty set 
input_clause(empty_set,axiom,
    [--member(Z,empty_set)]).

%----Definition of universal set 
input_clause(universal_set,axiom,
    [++member(Z,universal_set),
     --little_set(Z)]).

input_clause(complement_of_a_is_b,hypothesis,
    [++equal(complement(as),bs)]).

input_clause(complement_of_b_is_c,hypothesis,
    [++equal(complement(bs),cs)]).

input_clause(prove_a_equals_c,theorem,
    [--equal(as,cs)]).
%--------------------------------------------------------------------------
