%--------------------------------------------------------------------------
% File     : SET012=CpmtIvln-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Complement is an involution
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  269 (  20 non-Horn)(  15 unit)
%            Number of literals          :  632 ( 276 equality)
%            Number of predicate symbols :   14 (   0 propositional)
%            Number of function symbols  :   62 (   9 constant)
%            Number of variables         :  732 (  28 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%--------------------------------------------------------------------------
input_clause(complement_of_a_is_b,hypothesis,
    [++equal(complement(as),bs)]).

input_clause(complement_of_b_is_c,hypothesis,
    [++equal(complement(bs),cs)]).

input_clause(prove_a_equals_c,theorem,
    [--equal(as,cs)]).
%--------------------------------------------------------------------------
