%--------------------------------------------------------------------------
% File     : SET012=CpmtIvln-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Complement is an involution
% Version  : [McCharen, et al., 1976] axioms.
%            Theorem formulation : Modified.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : compl.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   35 (   3 non-Horn)(   6 unit)
%            Number of literals          :   74 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   80 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include set axioms 
include('Axioms/SET002-0.ax').
include('Axioms/SET002-0.eq').
%--------------------------------------------------------------------------
input_clause(complement_of_a_is_b,hypothesis,
    [++equal_sets(complement(a),b)]).

input_clause(complement_of_b_is_c,hypothesis,
    [++equal_sets(complement(b),c)]).

input_clause(prove_a_equals_c,theorem,
    [--equal_sets(a,c)]).
%--------------------------------------------------------------------------
