%--------------------------------------------------------------------------
% File     : SET011=Diff_Intsc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : A property of difference and intersection
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : The difference of a first set and the set which is the 
%            difference of the first set and a second set, is the 
%            intersection of the two sets.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls121 [Lawrence & Starkey, 1974]
%          : ls121 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   21 (   7 non-Horn)(   3 unit)
%            Number of literals          :   57 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   55 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and intersection axioms 
include('Axioms/SET001-2.ax').
%----Include the member and difference axioms 
include('Axioms/SET001-3.ax').
%--------------------------------------------------------------------------
input_clause(a_minus_b,hypothesis,
    [++difference(a,b,aDb)]).

input_clause(a_minus_aDb,hypothesis,
    [++difference(a,aDb,aD_aDb)]).

input_clause(prove_a_intersection_b_is_aD_aDb,theorem,
    [--intersection(a,b,aD_aDb)]).
%--------------------------------------------------------------------------
