%--------------------------------------------------------------------------
% File     : SET010=UnionEqn-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : c-a union c-b equals c-(the intersection of a and b)
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls118 [Lawrence & Starkey, 1974]
%          : ls118 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   29 (   9 non-Horn)(   5 unit)
%            Number of literals          :   79 (   0 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :   11 (   7 constant)
%            Number of variables         :   76 (   6 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and union axioms 
include('Axioms/SET001-1.ax').
%----Include the member and intersection axioms 
include('Axioms/SET001-2.ax').
%----Include the member and difference axioms 
include('Axioms/SET001-3.ax').
%--------------------------------------------------------------------------
input_clause(a_intersection_b,hypothesis,
    [++intersection(a,b,aIb)]).

input_clause(c_minus_a,hypothesis,
    [++difference(c,a,cDa)]).

input_clause(c_minus_b,hypothesis,
    [++difference(c,b,cDb)]).

input_clause(c_minus_aIb,hypothesis,
    [++difference(c,aIb,cD_aIb)]).

input_clause(prove_cDa_union_cDb_is_cD_aIb,theorem,
    [--union(cDa,cDb,cD_aIb)]).
%--------------------------------------------------------------------------
