%--------------------------------------------------------------------------
% File     : SET009=SubSEqn-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : If d is a subset of a, then b-a is a subset of b-d
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls116 [Lawrence & Starkey, 1974]
%          : ls116 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   16 (   5 non-Horn)(   4 unit)
%            Number of literals          :   38 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   34 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and difference axioms 
include('Axioms/SET001-3.ax').
%--------------------------------------------------------------------------
input_clause(d_is_a_subset_of_a,hypothesis,
    [++subset(d,a)]).

input_clause(b_minus_a,hypothesis,
    [++difference(b,a,bDa)]).

input_clause(b_minus_d,hypothesis,
    [++difference(b,d,bDd)]).

input_clause(prove_bDa_is_a_subset_of_bDd,theorem,
    [--subset(bDa,bDd)]).
%--------------------------------------------------------------------------
