%--------------------------------------------------------------------------
% File     : SET008=DiffEl-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Difference contains no operand elements
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : The difference of two sets contains no members of the 
%            subtracted set.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls115 [Lawrence & Starkey, 1974]
%          : ls115 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   21 (   7 non-Horn)(   3 unit)
%            Number of literals          :   57 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   56 (   5 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and intersection axioms 
include('Axioms/SET001-2.ax').
%----Include the member and difference axioms 
include('Axioms/SET001-3.ax').
%--------------------------------------------------------------------------
input_clause(b_minus_a,hypothesis,
    [++difference(b,a,bDa)]).

input_clause(a_intersection_bDa,theorem,
    [--intersection(a,bDa,aI_bDa)]).

input_clause(prove_aI_bDa_is_empty,theorem,
    [--member(A,aI_bDa)]).
%--------------------------------------------------------------------------
