%--------------------------------------------------------------------------
% File     : SET007=IntscUnion-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Intersection distributes over union
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls112 [Lawrence & Starkey, 1974]
%          : ls112 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   23 (   5 non-Horn)(   5 unit)
%            Number of literals          :   59 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :   10 (   7 constant)
%            Number of variables         :   55 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and union axioms 
include('Axioms/SET001-1.ax').
%----Include the member and intersection axioms 
include('Axioms/SET001-2.ax').
%--------------------------------------------------------------------------
input_clause(b_union_c,axiom,
    [++union(b,c,bUc)]).

input_clause(a_intersection_b,axiom,
    [++intersection(a,b,aIb)]).

input_clause(a_intersection_c,axiom,
    [++intersection(a,c,aIc)]).

input_clause(a_intersection_bUc,axiom,
    [++intersection(a,bUc,aI_bUc)]).

input_clause(prove_aIb_union_aIc_is_aI_bUc,theorem,
    [--union(aIb,aIc,aI_bUc)]).
%--------------------------------------------------------------------------
