%--------------------------------------------------------------------------
% File     : SET006=IntscSubS-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Intersection is a subset
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : If the intersection of two sets is the first of the two sets, 
%            then the first is a subset of the second.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls111 [Lawrence & Starkey, 1974]
%          : ls111 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   14 (   3 non-Horn)(   2 unit)
%            Number of literals          :   36 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   34 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and intersection axioms 
include('Axioms/SET001-2.ax').
%--------------------------------------------------------------------------
input_clause(d_intersection_a_is_d,hypothesis,
    [++intersection(d,a,d)]).

input_clause(prove_d_is_a_subset_of_a,theorem,
    [--subset(d,a)]).
%--------------------------------------------------------------------------
