%--------------------------------------------------------------------------
% File     : SET005=IntscAssc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Associativity of set intersection
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls108 [Lawrence & Starkey, 1974]
%          : ls108 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   16 (   3 non-Horn)(   4 unit)
%            Number of literals          :   38 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    8 (   6 constant)
%            Number of variables         :   34 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and intersection axioms 
include('Axioms/SET001-2.ax').
%--------------------------------------------------------------------------
input_clause(a_intersection_b,axiom,
    [++intersection(a,b,aIb)]).

input_clause(b_intersection_c,axiom,
    [++intersection(b,c,bIc)]).

input_clause(a_intersection_bIc,axiom,
    [++intersection(a,bIc,aIbIc)]).

input_clause(prove_aIb_intersection_c_is_aIbIc,theorem,
    [--intersection(aIb,c,aIbIc)]).
%--------------------------------------------------------------------------
