%--------------------------------------------------------------------------
% File     : SET002=UnionEqS-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : A set union itself is itself
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls103 [Lawrence & Starkey, 1974]
%          : ls103 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   14 (   3 non-Horn)(   2 unit)
%            Number of literals          :   36 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   34 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%----Include the member and union axioms 
include('Axioms/SET001-1.ax').
%--------------------------------------------------------------------------
input_clause(a_union_a_is_aUa,hypothesis,
    [++union(a,a,aUa)]).

input_clause(prove_a_equals_aUa,theorem,
    [--equal_sets(aUa,a)]).
%--------------------------------------------------------------------------
