%--------------------------------------------------------------------------
% File     : SET001=SupSEl-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Set members are superset members
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : A member of a set is also a member of that set's supersets.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls100 [Lawrence & Starkey, 1974]
%          : ls100 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :    9 (   1 non-Horn)(   3 unit)
%            Number of literals          :   17 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   13 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include the member and subset axioms 
include('Axioms/SET001-0.ax').
%--------------------------------------------------------------------------
input_clause(b_equals_bb,hypothesis,
    [++equal_sets(b,bb)]).

input_clause(element_of_b,hypothesis,
    [++member(element_of_b,b)]).

input_clause(prove_element_of_bb,theorem,
    [--member(element_of_b,bb)]).
%--------------------------------------------------------------------------
