%--------------------------------------------------------------------------
% File     : ROB025=RobBool12-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : -(X + Y) = intersection(-X,-Y) => Boolean
% Version  : [Winker, 1990] (equality) axioms.
% English  : If for all X and Y, -(X + Y) = intersection(-X,-Y) then the 
%            algebra is Boolean.

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
%          : Wos L., Winker S., McCune W.W., Overbeek R., Lusk E. and 
%            Stevens R. (1990), Automated Reasoning Contributes 
%            to Mathemetics and Logic, In Stickel M.E. (Ed), Proceedings 
%            of the 10th International Conference on Automated Deduction 
%            (Kaiserslautern, Germany, 1990), (Lecture Notes in Artificial 
%            Intelligence, 449), Springer-Verlag, NY, 485-499.
% Source   : [Wos, et al., 1990]
% Names    : RA-2 [Wos, et al., 1990]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   23 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : Commutativity, associativity, and Huntington's axiom 
%            axiomatize Boolean algebra.
%          : Intersection is not defined, so this problem may be broken.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(the_condition,hypothesis,
    [++equal(negate(add(X,Y)),intersect(negate(X),negate(Y)))]).

input_clause(prove_huntingtons_axiom,theorem,
    [--equal(add(negate(add(a,negate(b))),negate(add(negate(a),
negate(b)))),b)]).
%--------------------------------------------------------------------------
