%--------------------------------------------------------------------------
% File     : ROB017=Absb1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(2f + h) = -(3f + h) = -h then 2f + h = 3f + h
% Version  : [Winker, 1990] (equality) axioms.
% English  : That is, 2f+h absorbs f.

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 3.8 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   7 unit)
%            Number of literals          :   20 (  20 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   23 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : This is formulated without the numbers, by adding.
%          : The extra lemma is required for the proof.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%--------------------------------------------------------------------------
input_clause(condition1,hypothesis,
    [++equal(negate(add(f,add(f,h))),negate(h))]).

input_clause(condition2,hypothesis,
    [++equal(negate(add(f,add(f,add(f,h)))),negate(h))]).

%----This is the necessary lemma 
input_clause(lemma_3_7,axiom,
    [--equal(negate(add(X,negate(Y))),negate(Y)),
     ++equal(negate(add(Y,add(X,negate(add(X,negate(Y)))))),
negate(Y))]).

input_clause(prove_result,theorem,
    [--equal(add(f,add(f,add(f,h))),add(f,add(f,h)))]).
%--------------------------------------------------------------------------
