%--------------------------------------------------------------------------
% File     : ROB016=Eqn6-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(d + e) = -e then -(e + k(d + -(d + -e))) = -e, for k>0
% Version  : [Winker, 1990] (equality) axioms.
% English  : 

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Corollary 3.7 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   9 unit)
%            Number of literals          :   36 (  28 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    8

% Comments : The extra lemma is required for the proof.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for Robbins algebra numbers 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
input_clause(condition,hypothesis,
    [++equal(negate(add(d,e)),negate(e))]).

input_clause(k_positive,axiom,
    [++positive_integer(k)]).

%----Lemma 3.6 required 
input_clause(lemma_3_6,axiom,
    [--equal(negate(add(negate(Y),negate(add(X,negate(Y))))),X),
     --positive_integer(Vk),
     ++equal(negate(add(Y,multiply(Vk,add(X,negate(add(X,
negate(Y))))))),negate(Y))]).

input_clause(prove_result,theorem,
    [--equal(negate(add(e,multiply(k,add(d,negate(add(d,
negate(e))))))),negate(e))]).
%--------------------------------------------------------------------------
