%--------------------------------------------------------------------------
% File     : ROB015=Eqn5Indn-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(-e + -(d + -e)) = d then -(e + k(d + -(d + -e))) = -e, k=k+1
% Version  : [Winker, 1990] (equality) axioms.
% English  : This is the induction step of an induction proof.

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 3.6 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(  10 unit)
%            Number of literals          :   34 (  27 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   35 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    8

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for numbers in Robbins algebras 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
input_clause(condition,hypothesis,
    [++equal(negate(add(negate(e),negate(add(d,negate(e))))),d)]).

input_clause(k_positive,axiom,
    [++positive_integer(k)]).

input_clause(base_step,axiom,
    [--equal(negate(add(e,multiply(k,add(d,negate(add(d,negate(e))))))),
negate(e))]).

input_clause(prove_induction_step,theorem,
    [--equal(negate(add(e,multiply(successor(k),add(d,negate(add(d,
negate(e))))))),negate(e))]).
%--------------------------------------------------------------------------
