%--------------------------------------------------------------------------
% File     : ROB014=Eqn5Base-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(-e + -(d + -e)) = d then -(e + k(d + -(d + -e))) = -e, k=1
% Version  : [Winker, 1990] (equality) axioms : Augmented.
% English  : This is the base step of an induction proof.

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 3.6 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   8 unit)
%            Number of literals          :   37 (  30 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   42 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    8

% Comments : The extra lemmas are suggested by Winker (1990).
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for numbers in Robbins algebras 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
%----These are the extra lemmas 
input_clause(lemma_3_2,axiom,
    [--equal(negate(add(X,negate(add(Y,Z)))),negate(add(Y,negate(
add(X,Z))))),
     ++equal(X,Y)]).

input_clause(lemma_3_4,axiom,
    [--equal(negate(add(X,negate(Y))),Z),
     --positive_integer(Vk),
     ++equal(negate(add(X,negate(add(Y,multiply(Vk,add(X,Z)))))),Z)]).

%----Clauses for the theorem 
input_clause(condition,hypothesis,
    [++equal(negate(add(negate(e),negate(add(d,negate(e))))),d)]).

input_clause(prove_base_step,theorem,
    [--equal(negate(add(e,multiply(one,add(d,negate(add(d,
negate(e))))))),negate(e))]).
%--------------------------------------------------------------------------
