%--------------------------------------------------------------------------
% File     : ROB014=Eqn5Base-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Robbins Algebra
% Problem  : If -(-e + -(d + -e)) = d then -(e + k(d + -(d + -e))) = -e, k=1
% Version  : [Winker, 1990] (equality) axioms.
% English  : This is the base step of an induction proof.

% Refs     : Winker S. (1990), Robbins Algebra: Conditions That Make 
%            a Near-Boolean Algebra Boolean, Journal of Automated 
%            Reasoning 6(4), 465-489.
% Source   : [Winker, 1990]
% Names    : Lemma 3.6 [Winker, 1990]

% Status   : 
% Syntax   : Number of clauses           :   19 (   0 non-Horn)(   8 unit)
%            Number of literals          :   32 (  26 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   35 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    8

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include axioms for Robbins algebra 
include('Axioms/ROB001-0.ax').
%----Include axioms for numbers in Robbins algebras 
include('Axioms/ROB001-1.ax').
%--------------------------------------------------------------------------
input_clause(condition,hypothesis,
    [++equal(negate(add(negate(e),negate(add(d,negate(e))))),d)]).

input_clause(prove_base_step,theorem,
    [--equal(negate(add(e,multiply(one,add(d,negate(add(d,
negate(e))))))),negate(e))]).
%--------------------------------------------------------------------------
